% M-member n-dimensional CT-swarm
% The agents have point mass dynamics 
% Sliding mode control algorithm is used to force 
% motion along the gradient of the artivicial potential
% The algorithm uses the positions of all the other
% members to update its position 
% by Veysel Gazi

clear all; close all;clc;

global M n nn nnn u0 gamma;
global m_u_bar m_o_bar f_bar J_bar epsilon;
global m_nominal f_unknown;
global a b c;
global beta0 alpha0;
global w;

M = 3;   % # of swarm members
n = 2; % # of dimensions of the state space
nn = 2*n; % dimension of the agent dynamics
nnn = 3*n;

% Set a random IC
% x0 = 30*rand(nn, M);   
% Set a random initial positions and zero speed

x0 = [10*rand(n, M) 0*rand(n, 1); zeros(n, M+1); zeros(n, M+1)];  

m_u_bar = 0.5; % Lower bound on the mass
m_o_bar = 1.5; % Upper bound on the mass
m_nominal = 1.0; % Actual mass of the agents
f_bar = 1; % Upper bound on the additive disturbances
f_unknown = 1.0*ones(n,1); % The magnitude of the unknown part of the vehicle dynamics
epsilon = 1.0; % For finite time reaching
gamma = 10; % The constant for the smoothness of tanh

% Formation parameters
% a = 1;
% b = a/2;
% c = a/sqrt(3);
a = 1/5;
b = 2/5;
c = sqrt(3)/5;

w=0.1;

J_bar = 20*M; % Upper bound on the time derivative of the potential
%u0 = 10; % The gain of the sliding mode controller
u0 = (1/m_u_bar)*(m_o_bar*f_bar + J_bar + epsilon); % Controller gain
% Calculate the controller gain
%mxd = calculate_maxdist(x0(:,1:M),M);
%alpha0 = M*(a*mxd + b*sqrt(c/2)*exp(-1/2));
%beta0 = a + 2*b*exp(-3/2);
%J_bar = 2*M*beta0*alpha0;
%u0 = (1/m_u_bar)*(m_o_bar*f_bar + J_bar + epsilon);

t0 = 0.0;
tf = 32;
tspan = [t0 tf];
tspan = t0:(tf-t0)/100:tf;

myoptions = odeset('OutputFcn','odeplot');
[t, x] = ode23('peridetecting_derivative', tspan, x0, myoptions);

for i=1:M,
  xf(i, :) = x(size(x,1), nnn*(i-1)+1:nnn*i-n);
end;

% Find the center of the members
for i=1:size(x,1),
  ctr(i, :) = zeros(1,n);
  for j=1:M,
    ctr(i, :) = ctr(i, :) +  x(i, nnn*(j-1)+1:nnn*j-nn);
  end;
end;
ctr = ctr/M;
ctr0 = ctr(1, :);
%%
[r,l]=size(ctr);

if n == 3,

figure(1);
plot3(x0(1,:), x0(2,:), x0(3,:),'bo'); hold on;
for i=1:M,
  plot3(x(:, nn*(i-1)+1), x(:, nn*(i-1)+2), x(:, nn*(i-1)+3), '.'); 
end;
plot3(xf(:,1), xf(:,2), xf(:,3), 'ro'); hold off;
title('The paths of the swarm members');
grid

figure(2);
plot3(xf(:,1), xf(:,2), xf(:,3), 'ro'); hold on;
plot3(ctr(:,1), ctr(:,2), ctr(:,3), '*'); 
hold off;
title('The final positions of the swarm members');
grid

elseif n == 2,
    
figure(1);
plot(x0(1,1:M), x0(2,1:M), 'bo'); hold on;
plot(x0(1,M+1), x0(2,M+1), 'go');
for i=1:M,
  plot(x(:, nnn*(i-1)+1), x(:, nnn*(i-1)+2), '-'); 
end;
hold on;
plot(x(:, nnn*M+1), x(:, nnn*M+2), 'g--');
plot(x(r, nnn*M+1), x(r, nnn*M+2),'g*');
plot(ctr(r,1),ctr(r,2),'ko'); % black circle: center of the agents group
plot(xf(:,1), xf(:,2), 'ro'); 
for i=1:M,
  for j=i:M,
    plot([xf(i,1), xf(j,1)], [xf(i,2), xf(j,2)], 'r--');
  end;
end;
hold off;
title('The paths of the swarm members');
grid

figure(2);
plot(xf(:,1), xf(:,2), 'ro'); hold on;
plot(ctr(:,1), ctr(:,2), '-');
%for h=1:size(x,1)
% for i=1:M,
%   for j=i:M,
%     plot([xf(i,1), xf(j,1)], [xf(i,2), xf(j,2)], 'r--');
%     %plot([x(h,i), x(h,i)], [x(h,j+4), x(h,j+4)], 'r--');
%   end;
% end; 
%end;
for i=1:5:r,
     plot([x(i,1), x(i,nnn+1)], [x(i,2), x(i,nnn+2)], 'r--');
     plot([x(i,nnn+1), x(i,nnn*2+1)], [x(i,nnn+2), x(i,nnn*2+2)], 'r--');
     plot([x(i,nnn*2+1), x(i,1)], [x(i,nnn*2+2), x(i,2)], 'r--');
end;

hold off;
title('The swarm formation during the tracking process');
grid

end;

if 4 > 3 

for j=1:size(x,1),
  for i=1:M,
    z(i, :) = x(j, nn*(i-1)+1:nn*i-n);
  end;

  MM(j) = 0;
  cm(j) = 0;
  mm(j) = 1000000;
  for i=1:M-1,
    for k = i+1:M,
      if (norm(z(i, :) - z(k, :)) > MM(j))
        MM(j) = norm(z(i, :) - z(k, :));
      end;

      if (norm(z(i, :) - z(k, :)) < mm(j))
        mm(j) = norm(z(i, :) - z(k, :));
      end;
      
      cm(j) = cm(j) + norm(z(i, :) - z(k, :));
    end;
  end;

  cMM(j) = 0;
  ccm(j) = 0;
  cmm(j) = 1000000;
  for i=1:M,
    if (norm(z(i, :) - ctr0) > cMM(j))
      cMM(j) = norm(z(i, :) - ctr0);
    end;

    if (norm(z(i, :) - ctr0) < cmm(j))
      cmm(j) = norm(z(i, :) - ctr0);
    end;

    ccm(j) = ccm(j) + norm(z(i, :) - ctr0);
  end;

end;

cm = (2*cm)/(M*(M-1));
ccm = ccm/M;

figure(3);
%plot(t, cMM,'b--'); hold on;
plot(t, ccm,'r');
%plot(t, cmm,'g-.'); hold off;
grid;
%title('The distance to the center');
title('The average distance to the center');
xlabel('time');
ylabel('distance');
%legend('maximum', 'average', 'minimum');

figure(4);
plot(t, MM,'b--'); hold on;
plot(t, cm,'g-.');
plot(t, mm,'r'); hold off;
grid;
title('The intermember distances');
xlabel('time');
ylabel('distance');
legend('maximum', 'average', 'minimum');

end;

figure(5);
plot(t, ctr); 
title('The plot of the center movement');
xlabel('t');
ylabel('\bar{x}');
grid

% plot the value of J
% %%% J1
% for i=1:r,
% Jt(i)=(norm([x(i,1), x(i,2)]-[x(i,nnn*M+1), x(i,nnn*M+2)]) - a^2)^2+...
%       (norm([x(i,nnn+1), x(i,nnn+2)]-[x(i,nnn*M+1), x(i,nnn*M+2)]) - a^2)^2+...
%       (norm([x(i,nnn*2+1), x(i,nnn*2+2)]-[x(i,nnn*M+1), x(i,nnn*M+2)])^2 - a^2)^2;
% Jf(i)=gr([x(i,1), x(i,2)]-[x(i,nnn+1), x(i,nnn+2)], c)+...
%       gr([x(i,nnn+1), x(i,nnn+2)]-[x(i,nnn*2+1), x(i,nnn*2+2)], c)+...
%       gr([x(i,1), x(i,2)]-[x(i,nnn*2+1), x(i,nnn*2+2)], c);
% h(i)=(Jt(i)+w*Jf(i))/2;
% end;

%%% J2
for i=1:r,
Jt(i)=(norm([x(i,1), x(i,2)]-[x(i,nnn*M+1), x(i,nnn*M+2)]) - a^2)^2+...
      (norm([x(i,nnn+1), x(i,nnn+2)]-[x(i,nnn*M+1), x(i,nnn*M+2)]) - a^2)^2+...
      (norm([x(i,nnn*2+1), x(i,nnn*2+2)]-[x(i,nnn*M+1), x(i,nnn*M+2)])^2 - a^2)^2;
Jf(i)=(norm([x(i,1), x(i,2)]-[x(i,nnn+1), x(i,nnn+2)])^2 - c^2)^2+...
      (norm([x(i,nnn+1), x(i,nnn+2)]-[x(i,nnn*2+1), x(i,nnn*2+2)])^2 - c^2)^2+...
      (norm([x(i,1), x(i,2)]-[x(i,nnn*2+1), x(i,nnn*2+2)])^2 - c^2)^2;
h(i)=(Jt(i)+w*Jf(i))/2;
end;

figure,
plot(t, h);
title('The value of potential function J');
grid;

% function grepulsion = gr(y, d)
% 
% b = 20; c = 0.2;
% a = b*exp(-d*d/c);
% grepulsion = a*(norm(y)^2 + b*c*exp(-(norm(y)^2)/c);